<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Hashtag;

use Erlage\Photogram\Data\Models\AbstractFinder;
use Erlage\Photogram\Data\Tables\Hashtag\HashtagTable;

final class HashtagFinder extends AbstractFinder implements InterfaceHashtagSetter
{
    /**
     * setter interface
     */
    use TraitHashtagSetters;

    public function getTableName(): string
    {
        return HashtagTable::getTableName();
    }

    /**
     * @return mixed 
     */
    public function getAtrributeValue(string $attribute)
    {
        return $this -> {HashtagTable::CAMEL_CASE_MAP[$attribute]}
        ?? null;
    }

    public function popModelFromResults(): HashtagModel
    {
        return HashtagModel::createFromUntouchedBean_noException(parent::pop());
    }
}
